import hxvlc.flixel.FlxVideoSprite;

sonrun = new Character(0, 0, "sonic_run", false);
mikerun = new Character(0, 0, "micheal-rosen-run", false);
var introSound:FlxSound = FlxG.sound.load(Paths.sound("exeIntro"));

//
var exeTitlecard = new FlxSprite();
exeTitlecard.loadGraphic("images/stages/hell/title.png");
exeTitlecard.alpha = 0.001;
//
var exestatic:FlxSprite = new FlxSprite();
exestatic.cameras = [camHUD];
exestatic.frames = Paths.getFrames("stages/hell/exestatic");
exestatic.animation.addByPrefix("staticloop", "exestatic idle", 24, true);
exestatic.scale.set(4, 4);
exestatic.antialiasing = false;
exestatic.screenCenter();
//
var jumpscare:FlxSprite = new FlxSprite();
jumpscare.frames = Paths.getFrames("stages/hell/sonic-jumpscare");
jumpscare.animation.addByPrefix("jumploop", "sonic-jumpscare loop", 24, true);
jumpscare.scale.set(4, 4);
jumpscare.antialiasing = false;
jumpscare.screenCenter();
// ALL THE VIDEOS.....
if (FlxG.save.data.midsongvids_toggle) {
	var green:CustomShader = new CustomShader("NebulaGreenscreen");
	var camVideo:FlxCamera = new FlxCamera(0, 0, 960, 720);
	var michael1 = new FlxVideoSprite(60, -140);
	var michael2 = new FlxVideoSprite(60, -140);
	var end = new FlxVideoSprite(0, 0);

	// camera
	camVideo.bgColor = 0;
	FlxG.cameras.add(camVideo, false);
	// custom pause handler pre-requesite
	michael1.autoPause = false;
	michael2.autoPause = false;
	end.autoPause = false;
	//  -----
	michael1.load(Assets.getPath(Paths.video("nb-michael1")));
	michael2.load(Assets.getPath(Paths.video("nb-michael2")));
	for (i in [michael1, michael2]) {
		i.shader = green;
		i.scale.set(0.8, 0.8);
		i.visible = false;
	}
	//  -----
	end.load(Assets.getPath(Paths.video("fryingpan")));
	end.visible = false;
}
//
function create() {
	playCutscenes = true;
	PlayState.instance.introLength = 9;
	if (FlxG.save.data.midsongvids_toggle) {
		end.bitmap.onFormatSetup.add(function() {
			end.cameras = [camVideo];
			// end.scale.set(1.5, 1.5);
			end.updateHitbox();
		});
		add(end);
	}
}

function onCountdown(event:CountdownEvent) {
	event.cancel();
	switch (event.swagCounter) {
		case 1:
			FlxTween.tween(exeTitlecard, {alpha: 1}, 0.2);
			introSound.play(true);
	};
}

function onSubstateOpen() {
	if (!FlxG.save.data.midsongvids_toggle)
		return;
	for (i in [michael1, michael2, end])
		if (i.visible)
			i.pause();
}

function onSubstateClose() {
	if (!FlxG.save.data.midsongvids_toggle)
		return;
	for (i in [michael1, michael2, end])
		if (i.visible)
			i.play();
}

function postCreate() {
	camGame.visible = false;
	camHUD.visible = false;
	exeTitlecard.cameras = [camHUD2];
	exeTitlecard.screenCenter();
	add(exeTitlecard);

	// camGame.addShader(green);

	jumpscare.cameras = [camHUD];
	exestatic.animation.play('staticloop');
	exestatic.alpha = 0;
	jumpscare.alpha = 0;
	add(jumpscare);
	add(exestatic);

	defaultCamZoom = 0.7;
	FlxG.camera.zoom = defaultCamZoom;

	insert(members.indexOf(stage.getSprite("ground")), michael1);
	insert(members.indexOf(stage.getSprite("ground2")), michael2);
}

function onSongStart() {
	exeTitlecard.destroy();
	camHUD.fade(FlxColor.BLACK, (Conductor.stepCrochet / 1000) * 4, true);
	defaultCamZoom = 0.6;
	camGame.visible = true;
	camHUD.visible = true;
}

function stepHit() {
	switch (curStep) {
		case 110:
			if (FlxG.save.data.midsongvids_toggle)
				michael1.play();
		case 112:
			if (FlxG.save.data.midsongvids_toggle) {
				boyfriend.alpha = 0.001;
				michael1.visible = true;
			}
		case 128:
			if (FlxG.save.data.midsongvids_toggle) {
				boyfriend.alpha = 1;
				michael1.visible = false;
				remove(michael1);
			}
		case 736:
			jumpscare.alpha = 1;
			jumpscare.animation.play('jumploop');
		case 764:
			exestatic.alpha = 1;
			jumpscare.alpha = 0;
		case 768:
			camGame.shake(0.005, 17.7, null, true);
			camGame.followLerp = 0.1;
			exestatic.alpha = 0;
		case 1020:
			exestatic.alpha = 1;
		case 1024:
			exestatic.alpha = 0;
			camGame.followLerp = 0.04;
		case 1406:
			if (FlxG.save.data.midsongvids_toggle)
				michael2.play();
		case 1408:
			if (FlxG.save.data.midsongvids_toggle) {
				boyfriend.alpha = 0.001;
				michael2.visible = true;
			}
		case 1536:
			if (FlxG.save.data.midsongvids_toggle) {
				boyfriend.alpha = 1;
				michael2.visible = false;
				remove(michael2);
			}
		case 2016:
			jumpscare.alpha = 1;
			jumpscare.animation.play('jumploop');
		case 2040:
			jumpscare.alpha = 0;
		case 2048:
			camGame.shake(0.005, 17.7, null, true);
			camGame.followLerp = 0.1;
		case 2300:
			exestatic.alpha = 1;
		case 2304:
			exestatic.alpha = 0;
			camGame.followLerp = 0.04;
		case 2844:
			exestatic.alpha = 1;
		case 2848:
			if (FlxG.save.data.midsongvids_toggle) {
				end.play();
				end.visible = true;
			}
		case 2880:
			camGame.visible = false;
			camHUD.visible = false;
	}
}

function onSongEnd() {
	if (FlxG.save.data.midsongvids_toggle) remove(end);
}

function onGameOver(event) {
	camGame.visible = true;
	camHUD.visible = true;
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
 var videosToHandle:Array<FlxVideoSprite> = [michael1, michael2, end];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}
